//
//  CMS_Notification.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 21/01/15.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//

import UIKit
import Foundation

class CMS_Notification: NSObject {
    
    /*
        Register Application for Remote Notifications
    */
    class func registerForRemoteNotifications() {
        var application = UIApplication.sharedApplication()
            var userNotificationTypes = ([.Alert, .Badge, .Sound])
            var settings = UIUserNotificationSettings.settingsForTypes(userNotificationTypes, categories: nil)
            application.registerUserNotificationSettings(settings)
            application.registerForRemoteNotifications()
    }

    /*
        Parse device token from data
    */
    class func parseDeviceToken(deviceToken: NSData) -> String {
        var parsedDeviceToken = deviceToken.description.stringByTrimmingCharactersInSet<NSObject>(NSCharacterSet(charactersInString: "<>"))
        parsedDeviceToken = parsedDeviceToken.stringByReplacingOccurrencesOfString(" ", withString: "")
        DLog("parsedDeviceToken = %@", parsedDeviceToken)
        return parsedDeviceToken
    }

    /*
        Save and send device token to CMS server
    */
    class func notifyDeviceTokenToServer(deviceToken: String) {
        CMSNetworkManager.sharedManager().savePushTokenWithToken(deviceToken, onCompletion: {(response: [NSObject : AnyObject]) -> Void in
            DLog("Successfully saved push token to server")
            DLog("%@", response)
        }, onFaillure: {(error: NSError) -> Void in
            DLog("%@", error.description)
        }, showLoader: false)
    }

    /*
        Parse and show alert from received notification
    */
    class func showNotification(userInfo: [NSObject : AnyObject]) {
        var message: String? = nil
        var alert = (userInfo["aps"]["alert"] as! String)
        if (alert is String) {
            message = alert
        }
        else if (alert is [NSObject : AnyObject]) {
            message = (alert["body"] as! String)
        }

        if message == nil {
            var body = userInfo["body"]
            if body != nil && body.count > 0 {
                message = body[0]
            }
        }
        DLog(" push message = %@", message)
        if alert {
            UIAlertView(title: message, message: nil, delegate: nil, cancelButtonTitle: "ok").show()
        }
    }
}